/*= Gossen Metrawatt MSP Power Supply Include File ==============++==========*/
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __GMMSP_HEADER
#define __GMMSP_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Instrument Driver Specific Error/Warning Codes ==========================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_OFFSET                  (_VI_ERROR+0x3FFC0900L)

#define GMMSP_ERROR_INSTRUMENT_ERROR           (VI_ERROR_INSTR_OFFSET + 0xF0L)

/*****************************************************************************/
/*= Define Instrument Specific macros  ======================================*/
/*****************************************************************************/
#define CH1 	(1)
#define CH2		(2)
#define CH3		(4)
#define CH4		(8)
#define CH5		(16)
#define CH6		(32)
#define CH7		(64)
#define CH8		(128)

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC gmmsp_init (ViRsrc resourceName, ViBoolean IDQuery,
                              ViBoolean resetDevice, ViPSession instrumentHandle);
ViStatus _VI_FUNC gmmsp_AppExample (ViSession instrumentHandle, ViInt32 channel,
                                    ViReal64 voltageLimitinV,
                                    ViReal64 currentLimitinA,
                                    ViReal64 voltageSettinginV,
                                    ViReal64 currentSettinginA,
                                    ViPReal64 outputVoltageinV,
                                    ViPReal64 outputCurrentinA);
ViStatus _VI_FUNC gmmsp_confSetVolt (ViSession instrumentHandle, ViInt32 channel,
                                     ViReal64 voltageSettinginV);
ViStatus _VI_FUNC gmmsp_confGetVolt (ViSession instrumentHandle, ViInt32 channel,
                                     ViPReal64 voltageSettinginV);
ViStatus _VI_FUNC gmmsp_confSetVoltLimit (ViSession instrumentHandle,
                                          ViInt32 channel, ViReal64 voltageLimitinV);
ViStatus _VI_FUNC gmmsp_confGetVoltLimit (ViSession instrumentHandle,
                                          ViInt32 channel,
                                          ViPReal64 voltageLimitinV);
ViStatus _VI_FUNC gmmsp_confSetCurrent (ViSession instrumentHandle, ViInt32 channel,
                                        ViReal64 currentSettinginA);
ViStatus _VI_FUNC gmmsp_confGetCurrent (ViSession instrumentHandle, ViInt32 channel,
                                        ViPReal64 currentSettinginA);
ViStatus _VI_FUNC gmmsp_confSetCurrLimit (ViSession instrumentHandle,
                                          ViInt32 channel, ViReal64 currentLimitinA);
ViStatus _VI_FUNC gmmsp_confGetCurrLimit (ViSession instrumentHandle,
                                          ViInt32 channel,
                                          ViPReal64 currentLimitinA);
ViStatus _VI_FUNC gmmsp_confOutpComplSet (ViSession instrumentHandle,
                                          ViInt32 channel, ViBoolean outputState,
                                          ViInt32 foldbackModeSetting,
                                          ViReal64 foldbackDelayinsec,
                                          ViBoolean foldbackState,
                                          ViBoolean sinkState);
ViStatus _VI_FUNC gmmsp_confSetOutputState (ViSession instrumentHandle,
                                            ViInt32 channel, ViBoolean outputState);
ViStatus _VI_FUNC gmmsp_confGetOutputState (ViSession instrumentHandle,
                                            ViInt32 channel, ViPBoolean outputState);
ViStatus _VI_FUNC gmmsp_confSetOutputMode (ViSession instrumentHandle,
                                           ViInt32 channel,
                                           ViInt32 foldbackModeSetting);
ViStatus _VI_FUNC gmmsp_confGetOutputMode (ViSession instrumentHandle,
                                           ViInt32 channel,
                                           ViPInt32 foldbackModeSetting);
ViStatus _VI_FUNC gmmsp_confOutpFoldModAct (ViSession instrumentHandle,
                                            ViInt32 channel,
                                            ViPInt32 foldbackModeActual);
ViStatus _VI_FUNC gmmsp_confSetSourceState (ViSession instrumentHandle,
                                            ViInt32 channel, ViBoolean sourceState);
ViStatus _VI_FUNC gmmsp_confGetSourceState (ViSession instrumentHandle,
                                            ViInt32 channel, ViPBoolean sourceState);
ViStatus _VI_FUNC gmmsp_confSetSinkState (ViSession instrumentHandle,
                                          ViInt32 channel, ViBoolean sinkState);
ViStatus _VI_FUNC gmmsp_confGetSinkState (ViSession instrumentHandle,
                                          ViInt32 channel, ViPBoolean sinkState);
ViStatus _VI_FUNC gmmsp_confSetOCPDelay (ViSession instrumentHandle,
                                         ViInt32 channel,
                                         ViReal64 foldbackDelayinsec);
ViStatus _VI_FUNC gmmsp_confGetOCPDelay (ViSession instrumentHandle,
                                         ViInt32 channel,
                                         ViPReal64 foldbackDelayinsec);
ViStatus _VI_FUNC gmmsp_confSetOCPState (ViSession instrumentHandle,
                                         ViInt32 channel, ViBoolean foldbackState);
ViStatus _VI_FUNC gmmsp_confGetOCPState (ViSession instrumentHandle,
                                         ViInt32 channel, ViPBoolean foldbackState);
ViStatus _VI_FUNC gmmsp_confSetGroup (ViSession instrumentHandle,
                                      ViInt32 channelstogroup);
ViStatus _VI_FUNC gmmsp_confGetGroup (ViSession instrumentHandle,
                                      ViPInt32 channelsingroup);
ViStatus _VI_FUNC gmmsp_confSetGroupState (ViSession instrumentHandle,
                                           ViBoolean groupOutputState);
ViStatus _VI_FUNC gmmsp_confGetGroupState (ViSession instrumentHandle,
                                           ViPBoolean groupOutputState);
ViStatus _VI_FUNC gmmsp_confSetMeasGroup (ViSession instrumentHandle,
                                          ViInt32 channelstomeasuregroup);
ViStatus _VI_FUNC gmmsp_confGetMeasGroup (ViSession instrumentHandle,
                                          ViPInt32 channelsinmeasuregroup);
ViStatus _VI_FUNC gmmsp_confSetMinMaxState (ViSession instrumentHandle,
                                            ViBoolean minMaxState);
ViStatus _VI_FUNC gmmsp_confGetMinMaxState (ViSession instrumentHandle,
                                            ViPBoolean minMaxState);
ViStatus _VI_FUNC gmmsp_confSetPwrOnMode (ViSession instrumentHandle,
                                          ViInt32 powerMode);
ViStatus _VI_FUNC gmmsp_confGetPwrOnMode (ViSession instrumentHandle,
                                          ViPInt32 powerMode);
ViStatus _VI_FUNC gmmsp_resetMinMax (ViSession instrumentHandle);
ViStatus _VI_FUNC gmmsp_dataRecallRegister (ViSession instrumentHandle,
                                            ViInt32 registerNo);
ViStatus _VI_FUNC gmmsp_dataSaveRegister (ViSession instrumentHandle,
                                          ViInt32 registerNo);
ViStatus _VI_FUNC gmmsp_fetchMinMax (ViSession instrumentHandle, ViInt32 channel,
                                     ViPReal64 minVoltageinV,
                                     ViPReal64 maxVoltageinV,
                                     ViPReal64 minCurrentinA,
                                     ViPReal64 maxCurrentinA);
ViStatus _VI_FUNC gmmsp_measOutVolt (ViSession instrumentHandle, ViInt32 channel,
                                     ViPReal64 outputVoltage,
                                     ViBoolean checkMeasGroup,
                                     ViPBoolean validValue);
ViStatus _VI_FUNC gmmsp_measOutCurr (ViSession instrumentHandle, ViInt32 channel,
                                     ViPReal64 outputCurrent,
                                     ViBoolean checkMeasGroup,
                                     ViPBoolean validValue);
ViStatus _VI_FUNC gmmsp_measOutPower (ViSession instrumentHandle, ViInt32 channel,
                                      ViPReal64 outputPowerinW,
                                      ViBoolean checkMeasGroup,
                                      ViPBoolean validValue);
ViStatus _VI_FUNC gmmsp_measAllOutVolt (ViSession instrumentHandle,
                                        ViBoolean setMeasGroup, ViPReal64 channel1,
                                        ViPReal64 channel2, ViPReal64 channel3,
                                        ViPReal64 channel4, ViPReal64 channel5,
                                        ViPReal64 channel6, ViPReal64 channel7,
                                        ViPReal64 channel8);
ViStatus _VI_FUNC gmmsp_measAllOutCurr (ViSession instrumentHandle,
                                        ViBoolean setMeasGroup, ViPReal64 channel1,
                                        ViPReal64 channel2, ViPReal64 channel3,
                                        ViPReal64 channel4, ViPReal64 channel5,
                                        ViPReal64 channel6, ViPReal64 channel7,
                                        ViPReal64 channel8);
ViStatus _VI_FUNC gmmsp_measAllOutPower (ViSession instrumentHandle,
                                         ViBoolean setMeasGroup, ViPReal64 channel1,
                                         ViPReal64 channel2, ViPReal64 channel3,
                                         ViPReal64 channel4, ViPReal64 channel5,
                                         ViPReal64 channel6, ViPReal64 channel7,
                                         ViPReal64 channel8);
ViStatus _VI_FUNC gmmsp_errorCheckState (ViSession instrumentHandle,
                                         ViBoolean state);
ViStatus _VI_FUNC gmmsp_writeInstrData (ViSession instrumentHandle,
                                        ViString writeBuffer);
ViStatus _VI_FUNC gmmsp_readInstrData (ViSession instrumentHandle,
                                       ViInt32 numberBytesToRead,
                                       ViChar _VI_FAR readBuffer[],
                                       ViPInt32 numBytesRead);
ViStatus _VI_FUNC gmmsp_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC gmmsp_self_test (ViSession instrumentHandle,
                                   ViPInt16 selfTestResult,
                                   ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC gmmsp_error_query (ViSession instrumentHandle, ViPInt32 errorCode,
                                     ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC gmmsp_error_message (ViSession instrumentHandle,
                                       ViStatus statusCode,
                                       ViChar _VI_FAR message[]);
ViStatus _VI_FUNC gmmsp_revision_query (ViSession instrumentHandle,
                                        ViChar _VI_FAR instrumentDriverRevision[],
                                        ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC gmmsp_utilSetReg (ViSession instrumentHandle,
                                    ViInt32 systemRegisterName, ViInt32 value);
ViStatus _VI_FUNC gmmsp_utilGetReg (ViSession instrumentHandle,
                                    ViInt32 systemRegisterName, ViPInt32 value);
ViStatus _VI_FUNC gmmsp_utilSetDisplayState (ViSession instrumentHandle,
                                             ViBoolean displayState);
ViStatus _VI_FUNC gmmsp_utilGetDisplayState (ViSession instrumentHandle,
                                             ViPBoolean displayState);
ViStatus _VI_FUNC gmmsp_diag (ViSession instrumentHandle,
                              ViChar _VI_FAR diagnosticsMessage[]);
ViStatus _VI_FUNC gmmsp_utilSetDispText (ViSession instrumentHandle,
                                         ViString displaytext);
ViStatus _VI_FUNC gmmsp_utilGetDispText (ViSession instrumentHandle,
                                         ViChar _VI_FAR displaytext[]);
ViStatus _VI_FUNC gmmsp_utilSetIODelay (ViSession instrumentHandle,
                                        ViReal64 IODelayTime);
ViStatus _VI_FUNC gmmsp_utilGetIODelay (ViSession instrumentHandle,
                                        ViReal64 _VI_FAR IODelayTime[]);
ViStatus _VI_FUNC gmmsp_utilLockInstr (ViSession instrumentHandle,
                                       ViBoolean instrument);
ViStatus _VI_FUNC gmmsp_close (ViSession instrumentHandle);


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
